/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser;

import com.quantumdata.busmon.parser.DPCDCommandType;
import com.quantumdata.busmon.parser.DPCDMessage;
import com.quantumdata.busmon.parser.DPCDMessageType;
import com.quantumdata.busmon.parser.DPCDReplyMessage;
import com.quantumdata.busmon.parser.DPCDRequestMessage;
import com.quantumdata.busmon.parser.DataBlock;
import com.quantumdata.busmon.parser.TypeConverter;

public class DPRawI2CDataBlock
extends DataBlock {
    public static final int WAITING_FOR_REQUEST = 1;
    public static final int WAITING_FOR_REPLY = 2;
    private static final byte REQUEST_MASK = 48;
    private static final byte REQUEST_WRITE = 0;
    private static final byte REQUEST_READ = 16;
    private static final byte REQUEST_STATUS_UPDATE_REQUEST = 32;
    private static final byte REQUEST_RESERVED = 48;
    private static final byte REQUEST_MOT_MASK = 64;
    private static final byte REQUEST_MOT = 64;
    private static final short REPLY_MASK = 192;
    private static final short REPLY_I2C_ACK = 0;
    private static final short REPLY_I2C_NACK = 64;
    private static final short REPLY_I2C_DEFER = 128;
    private static final short REPLY_I2C_RESERVED = 192;
    private static final int GET_REQUEST_COMMAND = 1;
    private static final int GET_REQUEST_ADDRESS = 2;
    private static final int GET_REQUEST_DATA_LENGTH = 3;
    private static final int GET_REQUEST_DATA_BYTES = 4;
    private static final int GET_REPLY_COMMAND = 5;
    private static final int GET_REPLY_BYTES = 6;
    private static final int DONE = 7;
    private static final int ERROR = 8;
    protected Integer[] aRawPacket;
    protected long aTimestamp;
    protected long aPreviousBlockTimestamp;
    protected DPCDMessage aMessage;
    protected int aSourceID;
    private boolean aIsError = false;
    protected static DPRawI2CDataBlock sLastBlock = null;
    private static int sState = 1;
    private String aExplanation = "";
    private StringBuffer aStateMachineTransitions;
    private static final int PADDING = 2;
    private static boolean sIsMOT = false;

    public DPRawI2CDataBlock(Integer[] integerArray) {
        this.aRawPacket = (Integer[])integerArray.clone();
        this.aSourceID = integerArray[7];
        this.aTimestamp = TypeConverter.composeLong(integerArray, 8);
        this.aPreviousBlockTimestamp = sLastBlock == null ? 0L : sLastBlock.getTimestamp();
        this.aStateMachineTransitions = new StringBuffer("");
        this.aStateMachineTransitions.append("Initial State            Data Byte     Next State\n");
        this.parse(integerArray);
        sLastBlock = this;
    }

    public String getDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Timing Information\n");
        stringBuffer.append("------------------\n");
        stringBuffer.append("Time since last reset:  " + TypeConverter.getTimestampString(this.aTimestamp) + "\n");
        stringBuffer.append("Total Time From Last Received Message:  ");
        stringBuffer.append(TypeConverter.getTimeString(this.aTimestamp - this.aPreviousBlockTimestamp) + "\n\n");
        if (this.isError()) {
            stringBuffer.append("Error Information\n");
            stringBuffer.append("-----------------\n");
            String string = "No Error Information Available\n";
            if (!this.aExplanation.equalsIgnoreCase("")) {
                string = this.aExplanation;
            }
            stringBuffer.append(string + "\n");
        }
        stringBuffer.append("DPCD Message Details\n");
        stringBuffer.append("---------------------\n");
        if (this.aMessage != null) {
            stringBuffer.append(this.aMessage.getDetails() + "\n\n");
        } else {
            stringBuffer.append("This datablock does not contain a completed message.\n\n");
        }
        stringBuffer.append("DPCD Message Parsing State Transition Details\n");
        stringBuffer.append("---------------------------------------------\n");
        stringBuffer.append(this.aStateMachineTransitions.toString());
        return stringBuffer.toString();
    }

    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.aMessage != null) {
            stringBuffer.append(this.aMessage.getCommandTypeText());
            if (this.aMessage.getMessageType() == DPCDMessageType.READ_REQUEST) {
                DPCDRequestMessage dPCDRequestMessage = (DPCDRequestMessage)this.aMessage;
                stringBuffer.append(" " + dPCDRequestMessage.getDataLength() + " Bytes");
            } else {
                String string = DataBlock.getMessageDataAsHexString(this.aMessage);
                if (!string.equalsIgnoreCase("")) {
                    stringBuffer.append(" " + string);
                }
            }
        } else if (this.aRawPacket != null) {
            stringBuffer.append("Incomplete Message");
        }
        return stringBuffer.toString();
    }

    public String getType() {
        String string = "UNDEFINED";
        if (this.aMessage != null) {
            string = this.aMessage.getMessageTypeText();
        }
        return string;
    }

    public boolean isError() {
        return this.aIsError;
    }

    public Integer[] getRawMessage() {
        return this.aRawPacket;
    }

    public long getTimestamp() {
        return this.aTimestamp;
    }

    public int getSourceID() {
        return this.aSourceID;
    }

    private void parse(Integer[] integerArray) {
        switch (sState) {
            case 1: {
                boolean bl = this.parseRequest(integerArray);
                if (!bl && sLastBlock == null) {
                    sState = 1;
                    break;
                }
                if (bl) {
                    sState = 2;
                    StringBuffer stringBuffer = new StringBuffer("");
                    stringBuffer.append("Timestamp of this Request Message:  " + this.aTimestamp + "\n");
                    this.aExplanation = stringBuffer.toString();
                    break;
                }
                sState = 1;
                break;
            }
            case 2: {
                long l;
                boolean bl = this.parseReply(integerArray);
                if (bl && (l = this.aTimestamp - this.aPreviousBlockTimestamp) > 300L) {
                    StringBuffer stringBuffer = new StringBuffer("");
                    stringBuffer.append("Timestamp of this   Reply Message:  " + this.aTimestamp + "\n");
                    stringBuffer.append("Timestamp of last Request Message:  " + this.aPreviousBlockTimestamp + "\n");
                    stringBuffer.append("Difference:  " + l + "\n");
                    this.aExplanation = stringBuffer.toString();
                }
                sState = 1;
            }
        }
    }

    private boolean parseRequest(Integer[] integerArray) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        byte[] byArray = null;
        DPCDCommandType dPCDCommandType = DPCDCommandType.WRITE;
        DPCDMessageType dPCDMessageType = DPCDMessageType.WRITE_REQUEST;
        block8: for (int i = 12; i < integerArray.length && n2 != 8; ++i) {
            int n5 = integerArray[i];
            switch (n2) {
                case 1: {
                    if ((n5 & 0x8F) != 0) {
                        n2 = 8;
                        this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(1, n5, n2));
                        StringBuffer stringBuffer = new StringBuffer("");
                        if ((n5 & 0x80) != 0) {
                            stringBuffer.append("This is a native DisplayPort transaction\n");
                        } else {
                            stringBuffer.append("Invalid I2C address\n");
                        }
                        this.aExplanation = stringBuffer.toString();
                        continue block8;
                    }
                    if ((n5 & 0x40) == 64) {
                        bl2 = true;
                    }
                    sIsMOT = bl2;
                    if ((n5 & 0x30) == 0) {
                        dPCDCommandType = DPCDCommandType.WRITE;
                        dPCDMessageType = DPCDMessageType.WRITE_REQUEST;
                    } else if ((n5 & 0x30) == 16) {
                        dPCDCommandType = DPCDCommandType.READ;
                        dPCDMessageType = DPCDMessageType.READ_REQUEST;
                    } else if ((n5 & 0x30) == 32) {
                        dPCDCommandType = DPCDCommandType.UPDATE;
                        dPCDMessageType = DPCDMessageType.STATUS_UPDATE_REQUEST;
                    } else if ((n5 & 0x30) == 48) {
                        n2 = 8;
                        this.aExplanation = "Invalid Request Command:  48\n";
                        continue block8;
                    }
                    n2 = 2;
                    this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(1, n5, n2));
                    continue block8;
                }
                case 2: {
                    if (!bl3) {
                        if (n5 != 0) {
                            n2 = 8;
                            this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(2, n5, n2));
                            this.aExplanation = "Invalid I2C Address\n";
                            continue block8;
                        }
                        bl3 = true;
                        n2 = 2;
                        this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(2, n5, n2));
                        continue block8;
                    }
                    if ((n5 & 0x80) == 128) {
                        n2 = 8;
                        this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(2, n5, n2));
                        this.aExplanation = "Invalid I2C Address\n";
                        continue block8;
                    }
                    n = n5;
                    if (i == integerArray.length - 1) {
                        n2 = 7;
                        this.aMessage = new DPCDRequestMessage(dPCDMessageType, dPCDCommandType, n, 0, sIsMOT);
                        this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(2, n5, n2));
                        continue block8;
                    }
                    n2 = 3;
                    this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(2, n5, n2));
                    continue block8;
                }
                case 3: {
                    n3 = n5 + 1;
                    if (dPCDMessageType == DPCDMessageType.READ_REQUEST) {
                        if (n3 > 16) {
                            n2 = 8;
                            this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(3, n5, n2));
                            this.aExplanation = "Invalid Data Length '" + n3 + "' exceeds maximum of 16\n";
                            continue block8;
                        }
                        this.aMessage = new DPCDRequestMessage(dPCDMessageType, dPCDCommandType, n, n3, sIsMOT);
                        n2 = 7;
                        this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(3, n5, n2));
                        continue block8;
                    }
                    if (n3 > 16) {
                        n2 = 8;
                        this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(3, n5, n2));
                        this.aExplanation = "Invalid Data Length '" + n3 + "' exceeds maximum of 16\n";
                        continue block8;
                    }
                    byArray = new byte[n3];
                    n4 = 0;
                    n2 = 4;
                    this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(3, n5, n2));
                    continue block8;
                }
                case 4: {
                    byArray[n4] = (byte)n5;
                    if (++n4 < n3) {
                        n2 = 4;
                        this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(4, n5, n2));
                        continue block8;
                    }
                    this.aMessage = new DPCDRequestMessage(dPCDMessageType, dPCDCommandType, n, byArray, sIsMOT);
                    n2 = 7;
                    this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(4, n5, n2));
                    continue block8;
                }
                case 7: {
                    n2 = 8;
                    this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(7, n5, n2));
                    this.aExplanation = "Excess invalid bytes at the end of this packet\n";
                    continue block8;
                }
                case 8: {
                    n2 = 8;
                    this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(8, n5, n2));
                }
            }
        }
        if (n2 != 8 && n2 != 7) {
            this.aStateMachineTransitions.append(DPRawI2CDataBlock.getFormattedStateText(n2) + "No Data       " + DPRawI2CDataBlock.getFormattedStateText(8) + "\n");
            n2 = 8;
            this.aExplanation = "Incomplete Data Packet\n";
        }
        if (n2 == 8) {
            bl = false;
            this.aIsError = true;
        }
        return bl;
    }

    private boolean parseReply(Integer[] integerArray) {
        boolean bl = true;
        int n = 5;
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = null;
        DPCDCommandType dPCDCommandType = DPCDCommandType.UNDEFINED;
        DPCDMessageType dPCDMessageType = DPCDMessageType.UNDEFINED;
        block11: for (int i = 12; i < integerArray.length && n != 8; ++i) {
            int n4 = integerArray[i];
            switch (n) {
                case 5: {
                    if ((n4 & 0x3F) != 0) {
                        n = 8;
                        this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(5, n4, n));
                        if ((n4 & 0x30) != 0) {
                            this.aExplanation = "Invalid Reply Command Byte - Specifies a Native DisplayPort Transaction\n";
                            continue block11;
                        }
                        this.aExplanation = "Invalid Reply Command Byte - Corrupted Content\n";
                        continue block11;
                    }
                    DPCDMessageType dPCDMessageType2 = this.getLastMessageType();
                    switch (dPCDMessageType2) {
                        case READ_REQUEST: {
                            dPCDMessageType = DPCDMessageType.REPLY_TO_READ_REQUEST;
                            break;
                        }
                        case WRITE_REQUEST: {
                            dPCDMessageType = DPCDMessageType.REPLY_TO_WRITE_REQUEST;
                            break;
                        }
                        case STATUS_UPDATE_REQUEST: {
                            dPCDMessageType = DPCDMessageType.REPLY_TO_STATUS_UPDATE_REQUEST;
                            break;
                        }
                        default: {
                            n = 8;
                            this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(5, n4, n));
                            this.aExplanation = "Cannot Reply to a Reply Message\n";
                        }
                    }
                    if ((n4 & 0xC0) == 0) {
                        dPCDCommandType = DPCDCommandType.AUX_ACK;
                        if (i == integerArray.length - 1) {
                            n = 7;
                            this.aMessage = new DPCDReplyMessage(dPCDMessageType, dPCDCommandType, sIsMOT);
                            this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(5, n4, n));
                            continue block11;
                        }
                        n2 = 0;
                        n3 = integerArray.length - 1 - i;
                        byArray = new byte[n3];
                        n = 6;
                        this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(5, n4, n));
                        continue block11;
                    }
                    if ((n4 & 0xC0) == 64) {
                        if (dPCDMessageType != DPCDMessageType.REPLY_TO_WRITE_REQUEST) {
                            n = 8;
                            this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(5, n4, n));
                            this.aExplanation = "Cannot NACK a Previous Read Request Message\n";
                            continue block11;
                        }
                        dPCDCommandType = DPCDCommandType.AUX_NACK;
                        n2 = 0;
                        n3 = 1;
                        byArray = new byte[n3];
                        n = 6;
                        this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(5, n4, n));
                        continue block11;
                    }
                    if ((n4 & 0xC0) == 128) {
                        dPCDCommandType = DPCDCommandType.AUX_DEFER;
                        n = 7;
                        this.aMessage = new DPCDReplyMessage(dPCDMessageType, dPCDCommandType, sIsMOT);
                        this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(5, n4, n));
                        continue block11;
                    }
                    if ((n4 & 0xC0) != 192) continue block11;
                    n = 8;
                    this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(5, n4, n));
                    this.aExplanation = "I2C_RESERVED is an Invalid Reply Command Type\n";
                    continue block11;
                }
                case 6: {
                    byArray[n2] = (byte)n4;
                    if (++n2 == n3) {
                        n = 7;
                        this.aMessage = new DPCDReplyMessage(dPCDMessageType, dPCDCommandType, byArray, sIsMOT);
                        this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(6, n4, n));
                        continue block11;
                    }
                    n = 6;
                    this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(6, n4, n));
                    continue block11;
                }
                case 7: {
                    n = 8;
                    this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(7, n4, n));
                    this.aExplanation = "Excess invalid bytes at the end of this packet\n";
                    continue block11;
                }
                case 8: {
                    n = 8;
                    this.aStateMachineTransitions.append(DPRawI2CDataBlock.makeDisplayString(8, n4, n));
                }
            }
        }
        if (n != 8 && n != 7) {
            this.aStateMachineTransitions.append(DPRawI2CDataBlock.getFormattedStateText(n) + "No Data       " + DPRawI2CDataBlock.getFormattedStateText(8) + "\n");
            n = 8;
            this.aExplanation = "Incomplete Data Packet\n";
        }
        if (n == 8) {
            bl = false;
            this.aIsError = true;
        }
        return bl;
    }

    private DPCDMessageType getLastMessageType() {
        DPCDMessage dPCDMessage;
        DPCDMessageType dPCDMessageType = DPCDMessageType.UNDEFINED;
        if (sLastBlock != null && (dPCDMessage = DPRawI2CDataBlock.sLastBlock.aMessage) != null) {
            dPCDMessageType = dPCDMessage.getMessageType();
        }
        return dPCDMessageType;
    }

    public static String getDataValueAsHexString(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        String string2 = string.length() == 1 ? "0x0" : "0x";
        String string3 = string2 + string;
        StringBuffer stringBuffer = new StringBuffer(string3);
        int n2 = 14 - string3.length();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private static String getStateText(int n) {
        String string = "UNDEFINED";
        switch (n) {
            case 1: {
                string = "GET_REQUEST_COMMAND";
                break;
            }
            case 2: {
                string = "GET_REQUEST_ADDRESS";
                break;
            }
            case 3: {
                string = "GET_REQUEST_DATA_LENGTH";
                break;
            }
            case 4: {
                string = "GET_REQUEST_DATA_BYTES";
                break;
            }
            case 5: {
                string = "GET_REPLY_COMMAND";
                break;
            }
            case 6: {
                string = "GET_REPLY_BYTES";
                break;
            }
            case 7: {
                string = "DONE";
                break;
            }
            case 8: {
                string = "ERROR";
                break;
            }
        }
        return string;
    }

    private static int getMaximumStateDescriptionLength() {
        int n = 0;
        for (int i = 1; i <= 8; ++i) {
            String string = DPRawI2CDataBlock.getStateText(i);
            if (string.length() <= n) continue;
            n = string.length();
        }
        return n;
    }

    public static String getFormattedStateText(int n) {
        StringBuffer stringBuffer = new StringBuffer("" + DPRawI2CDataBlock.getStateText(n));
        int n2 = DPRawI2CDataBlock.getMaximumStateDescriptionLength() - stringBuffer.length() + 2;
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private static String makeDisplayString(int n, int n2, int n3) {
        return DPRawI2CDataBlock.getFormattedStateText(n) + DPRawI2CDataBlock.getDataValueAsHexString(n2) + DPRawI2CDataBlock.getFormattedStateText(n3) + "\n";
    }
}

